<?php
include 'conexao.php';

$aluno_id = $_GET['aluno_id'] ?? null;
$ano_inicio = $_GET['ano_inicio'] ?? ($_GET['ano_lectivo'] ?? null);
$origem = $_GET['origem'] ?? 'anterior';

if (!$aluno_id) {
    echo "Aluno não definido.";
    exit;
}

// Buscar dados do aluno com base na origem
if ($origem === 'atual') {
    $sqlAluno = "SELECT * FROM alunos WHERE id = $aluno_id";
} else {
    $sqlAluno = "SELECT * FROM alunos_anteriores WHERE id = $aluno_id";
}
$resAluno = $conn->query($sqlAluno);
$aluno = $resAluno->fetch_assoc();

if (!$aluno) {
    echo "Aluno não encontrado.";
    exit;
}

$foto = !empty($aluno['foto']) && file_exists("uploads/fotos/" . $aluno['foto']) ? "uploads/fotos/" . $aluno['foto'] : null;

// Buscar termos anteriores ordenados
$sql = "SELECT * FROM termos_anteriores WHERE aluno_id = $aluno_id ORDER BY ano_lectivo ASC";
$result = $conn->query($sql);

$dados_completos = [];
$classes_mais_recentes = [];

while ($row = $result->fetch_assoc()) {
    $classe = $row['classe'];
    $ano = $row['ano_lectivo'];
    $dados_completos[] = $row;
    $classes_mais_recentes[$classe] = $ano;
}

// Filtrar registros do último ano por classe (e >= ano_inicio se fornecido)
$registros_finais = [];
foreach ($dados_completos as $linha) {
    $classe = $linha['classe'];
    $ano = $linha['ano_lectivo'];
    if ($classes_mais_recentes[$classe] === $ano) {
        if (!$ano_inicio || strcmp($ano, $ano_inicio) >= 0) {
            $registros_finais[$ano][] = $linha;
        }
    }
}

// Gerar lista de anos para o seletor
$anos_disponiveis = [];
$res_anos = $conn->query("SELECT DISTINCT ano_lectivo FROM termos_anteriores ORDER BY ano_lectivo");
while ($row = $res_anos->fetch_assoc()) {
    $anos_disponiveis[] = $row['ano_lectivo'];
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Termos Anteriores - <?= $aluno['nome'] ?></title>
    <style>
        body { font-family: Arial, sans-serif; background: #f4f4f4; padding: 20px; }
        h2 { color: #1d3557; }
        .cabecalho { border: 1px solid black; padding: 15px; background: white; margin-bottom: 20px; }
        .cabecalho h4, .cabecalho h3 { margin: 2px 0; text-align: center; }
        .linha { display: flex; justify-content: space-between; gap: 20px; margin-top: 15px; }
        .dados { width: 75%; }
        .foto { width: 25%; height: 150px; border: 1px solid black; display: flex; align-items: center; justify-content: center; }
        .foto img { max-width: 100%; max-height: 100%; }
        .tabelas-container { display: flex; flex-wrap: wrap; gap: 20px; }
        .tabela-bloco { width: 32%; background: white; padding: 10px; box-shadow: 0 0 5px #ccc; border-radius: 5px; }
        table { border-collapse: collapse; width: 100%; font-size: 12px; }
        th, td { border: 1px solid #aaa; padding: 6px; text-align: center; }
        th { background-color: #457b9d; color: white; }
        #print-btn { background: #1d3557; color: white; padding: 10px 20px; border: none; font-size: 16px; cursor: pointer; margin: 10px 0; border-radius: 5px; }
        @media print {
            #print-btn, form { display: none; }
            .tabela-bloco { width: 100% !important; margin-bottom: 30px; page-break-inside: avoid; }
        }
    </style>
</head>
<body>

<h2>Termos Anteriores - <?= $aluno['nome'] ?></h2>

<!-- Seletor de ano -->
<form method="GET" action="termos_anteriores.php">
    <input type="hidden" name="aluno_id" value="<?= $aluno_id ?>">
    <input type="hidden" name="origem" value="<?= $origem ?>">
    <label><strong>Selecionar Ano Inicial:</strong></label>
    <select name="ano_inicio">
        <option value="">-- Todos --</option>
        <?php foreach ($anos_disponiveis as $ano): ?>
            <option value="<?= $ano ?>" <?= $ano == $ano_inicio ? 'selected' : '' ?>><?= $ano ?></option>
        <?php endforeach; ?>
    </select>
    <button type="submit">Ver Termos</button>
</form>

<!-- Cabeçalho institucional -->
<div class="cabecalho">
    <div style="text-align: center;">
        <img src="insignia/insignia.png" alt="Insígnia" style="width: 70px; margin-bottom: 10px;">
        <h4>REPÚBLICA DE ANGOLA</h4>
        <h4>GOVERNO PROVINCIAL DE BENGUELA</h4>
        <h4>GABINETE PROVINCIAL DA EDUCAÇÃO</h4>
        <h4>COMPLEXO ESCOLAR BG 0026 PADRE EMIL FRICK – CATUMBELA</h4>
        <h3>TERMO DE MATRÍCULA, FREQUÊNCIA, APROVEITAMENTO E EXAME Nº _______/_____ Nº PROC. INDIVIDUAL _______________</h3>
    </div>

    <div class="linha">
        <div class="dados">
            <?php
            $data_nascimento = $aluno['data_nascimento'] ?? null;
            $nascimento_formatado = ($data_nascimento && strtotime($data_nascimento)) ?
                date('d', strtotime($data_nascimento)) . ' de ' . date('m', strtotime($data_nascimento)) . ' de ' . date('Y', strtotime($data_nascimento)) :
                '____ de ______ de ______';

            $data_emissao_bi = $aluno['data_emissao_bi'] ?? null;
            $emissao_bi_formatada = ($data_emissao_bi && strtotime($data_emissao_bi)) ?
                date('d/m/Y', strtotime($data_emissao_bi)) : '____/____/______';
            ?>

            <p><strong>Nome:</strong> <?= $aluno['nome'] ?? '__________________________' ?>, nascido(a) aos <?= $nascimento_formatado ?>, natural de <?= $aluno['naturalidade'] ?? '_________________' ?></p>
            <p><strong>Município:</strong> <?= $aluno['municipio'] ?? '__________' ?>, <strong>Província:</strong> <?= $aluno['provincia'] ?? '__________' ?></p>
            <p><strong>Filho de:</strong> <?= $aluno['nome_pai'] ?? '_________________' ?> e de <?= $aluno['nome_mae'] ?? '_________________' ?></p>
            <p><strong>B.I Nº:</strong> <?= $aluno['bi'] ?? '______________' ?> emitido em <?= $emissao_bi_formatada ?></p>
            <p><strong>Residente em:</strong> <?= $aluno['residencia'] ?? '_________________' ?></p>
            <p><strong>Encarregado:</strong> <?= $aluno['encarregado'] ?? '_________________' ?>, <strong>Contactos:</strong> <?= $aluno['contacto'] ?? '________ / ________' ?></p>
        </div>
        <div class="foto">
            <?php if ($foto): ?>
                <img src="<?= $foto ?>" alt="Foto do aluno">
            <?php else: ?>
                FOTOGRAFIA
            <?php endif; ?>
        </div>
    </div>
</div>

<?php if (!empty($registros_finais)): ?>
    <button id="print-btn" onclick="window.print()">🖨️ Imprimir Tudo</button>
<?php endif; ?>

<div class="tabelas-container">
    <?php
    if (!empty($registros_finais)) {
        foreach ($registros_finais as $ano => $linhas) {
            echo '<div class="tabela-bloco">';
            echo "<h4>Ano Lectivo: $ano</h4>";
            echo '<table>
                    <thead>
                        <tr>
                            <th>Classe</th>
                            <th>Curso</th>
                            <th>Disciplina</th>
                            <th>MT1</th>
                            <th>MT2</th>
                            <th>MT3</th>
                            <th>MFD</th>
                            <th>NE</th>
                            <th>MF</th>
                            <th>REC</th>
                        </tr>
                    </thead>
                    <tbody>';
            foreach ($linhas as $linha) {
                echo "<tr>
                        <td>{$linha['classe']}</td>
                        <td>{$linha['curso']}</td>
                        <td>{$linha['disciplina']}</td>
                        <td>{$linha['mt1']}</td>
                        <td>{$linha['mt2']}</td>
                        <td>{$linha['mt3']}</td>
                        <td>{$linha['mfd']}</td>
                        <td>{$linha['ne']}</td>
                        <td>{$linha['mf']}</td>
                        <td></td>
                      </tr>";
            }
            echo '</tbody></table></div>';
        }
    } else {
        echo "<p><i>Nenhum termo encontrado para os critérios selecionados.</i></p>";
    }
    ?>
</div>

</body>
</html>
